//
//  Error.h
//  FishinMobile
//
//  Created by Arslan Ilyas on 27/09/2013.
//  Copyright (c) 2013 Rapidzz. All rights reserved.
//
import UIKit
import Foundation
class Error: NSObject {
    var errorCode = ""
    var message = ""
    
    /**
     ** Initialize Error with @dictResult dictionary
     ** @dictResult is the dictionary that contains error-code and related error-messages.
     **/
    override init(dictionary dictResult: [NSObject : AnyObject]) {
        super.init()
        
        //self.errorCode = dictResult[@"errorcode"];
        self.message = dictResult["error"]
        if self.message == nil {
            self.message = dictResult["error"]
        }
    
    }
    
    /**
     ** Initialize with @error
     **/
    override init(error: NSError?) {
        super.init()
        
        //self.errorCode = [[NSString alloc]initWithFormat:@"%d",[error code]];
        self.message = error.localizedDescription
    
    }
    
    /**
     ** Initialize with @message & @errorCode
     **/
    override init(message: String, errorCode code: String) {
        super.init()
        
        //self.errorCode = code;
        self.message = message
    
    }
     
    /**
     ** Describe the error
     ** Used in log statements
     **/
    override func description() -> String {
        return self.message
    }
}